/*
 * adc_inc_ioctl.h
 *
 * ioctl defination for adc-inc driver
 *
 *   Copyright (c) 2013 Robert Bosch GmbH, Hildesheim
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 */

#ifndef ADC_INC_IOCTL_H
#define ADC_INC_IOCTL_H

#include <linux/bosch_ioctl.h>
#include <stdbool.h>

enum devadc_comparision {
	devadc_threshold_lt = 0,
	devadc_threshold_gt,
	devadc_threshold_uk,
};

struct dev_threshold {
	u16 threshold;
	enum devadc_comparision encomparision;
};

#define PE_DEVADC_IOCSET_THRESHOLD _IOW(BOSCH_MAGIC_ADC_INC, 1\
							, struct dev_threshold)
#define PE_DEVADC_IOCGET_CONFIG    _IOR(BOSCH_MAGIC_ADC_INC, 2\
							, u8)

#endif /* ADC_INC_IOCTL_H_ */
